// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /var/mnt/Data/CVS_REPO/Clients/Marketcircle/Frameworks/MCApplication/MCCollapsibleSplitView.h,v 1.1 2006/03/19 21:54:58 alykhan Exp $

// Modified by AJ - late in the game for 3.0 release - do not want to risk problems by modifying MCSplitView. This is essentially a copy with programmatic collapsing behavior



#import <Cocoa/Cocoa.h>

@interface MCCollapsibleSplitView : NSSplitView
{
    NSString 	*positionAutosaveName;
	NSColor		*dividerColor;
	NSImage		*dividerImage;

	NSMutableDictionary *collapsedSubviewsDict;
	
	BOOL doNotDrawDivider;
	BOOL doNotAcceptMouseEvents;
	
}

- (void) collapseSubviewAt:(int)offset;

- (void)setPositionAutosaveName:(NSString *)name;
- (NSString *)positionAutosaveName;

- (void)setDividerColor:(NSColor *)aColor;
- (NSColor *)dividerColor;

- (void)setDividerImage:(NSImage *)anImage;
- (NSImage *)dividerImage;

- (BOOL)doNotDrawDivider;
- (void)setDoNotDrawDivider:(BOOL)flag;
- (BOOL)doNotAcceptMouseEvents;
- (void)setDoNotAcceptMouseEvents:(BOOL)flag;

- (NSArray *)splitProportions;
- (void)setSplitProportions:(NSArray *)array;
@end


@interface NSObject (MCCollapsibleSplitViewDelegate)

- (void)splitViewDidFinishReszingSubviews: (MCCollapsibleSplitView*)sender;

@end
